/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.integration.modules.jeirei.CompatLayerHelper;
import appeng.integration.modules.jeirei.CraftingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.me.items.CraftingTermMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, CraftingRecipe> {
    private final Class<T> menuClass;
    private final MenuType<T> menuType;
    private final IRecipeTransferHandlerHelper helper;

    public UseCraftingRecipeTransfer(Class<T> menuClass, MenuType<T> menuType, IRecipeTransferHandlerHelper helper) {
        this.menuClass = menuClass;
        this.menuType = menuType;
        this.helper = helper;
    }

    public IRecipeTransferError transferRecipe(T menu, CraftingRecipe recipe, IRecipeSlotsView display, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.m_6671_() != net.minecraft.world.item.crafting.RecipeType.f_44107_) {
            return this.helper.createInternalError();
        }
        if (recipe.m_7527_().isEmpty()) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        if (!recipe.m_8004_(3, 3)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        boolean craftMissing = AbstractContainerScreen.m_96637_();
        List inputSlots = display.getSlotViews(RecipeIngredientRole.INPUT);
        Map<Integer, Ingredient> slotToIngredientMap = UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new ErrorRenderer(missingSlots, craftMissing, color);
            }
        } else {
            CraftingHelper.performTransfer(menu, recipe, craftMissing);
        }
        return null;
    }

    private static Map<Integer, Ingredient> getGuiSlotToIngredientMap(Recipe<?> recipe) {
        int height;
        int width;
        if (CompatLayerHelper.IS_LOADED) {
            return appeng.integration.modules.rei.transfer.UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe);
        }
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            width = shapedRecipe.m_44220_();
            height = shapedRecipe.m_44221_();
        } else if (ingredients.size() > 4) {
            height = 3;
            width = 3;
        } else if (ingredients.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        LinkedHashMap<Integer, Ingredient> result = new LinkedHashMap<Integer, Ingredient>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = UseCraftingRecipeTransfer.getCraftingIndex(i, width, height);
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    public Class<T> getContainerClass() {
        return this.menuClass;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    private record ErrorRenderer(CraftingTermMenu.MissingIngredientSlots indices, boolean craftMissing, int color) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public int getButtonHighlightColor() {
            return this.color;
        }

        public void showError(PoseStack poseStack, int mouseX, int mouseY, IRecipeSlotsView slots, int recipeX, int recipeY) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)recipeX, (double)recipeY, 0.0);
            List slotViews = slots.getSlotViews(RecipeIngredientRole.INPUT);
            for (int i = 0; i < slotViews.size(); ++i) {
                IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
                boolean missing = this.indices.missingSlots().contains(i);
                boolean craftable = this.indices.craftableSlots().contains(i);
                if (!missing && !craftable) continue;
                slotView.drawHighlight(poseStack, missing ? 0x66FF0000 : 0x400000FF);
            }
            poseStack.m_85849_();
            List<Component> tooltip = TransferHelper.createCraftingTooltip(this.indices, this.craftMissing);
            JEIPlugin.drawHoveringText(poseStack, tooltip, mouseX, mouseY);
        }
    }
}

